package com.ejie.ab04b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.dao.ApartadoAnexoIIDao;
import com.ejie.ab04b.model.ApartadoAnexoII;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Ab04b86s00ServiceImpl generated by UDA, 11-Jan-2017 12:23:08.
 * 
 * @author UDA
 */

@Service(value = "ab04b86s00Service")
public class ApartadoAnexoIIServiceImpl implements ApartadoAnexoIIService {

	@Autowired()
	private ApartadoAnexoIIDao ab04b86s00Dao;

	/**
	 * Inserts a single row in the Ab04b86s00 table.
	 * 
	 *  ab04b86s00
	 *            Ab04b86s00
	 *  Ab04b86s00
	 *
	 * @param ab04b86s00 the ab 04 b 86 s 00
	 * @return the apartado anexo II
	 */
	@Transactional(rollbackFor = Throwable.class)
	public ApartadoAnexoII add(ApartadoAnexoII ab04b86s00) {
		return this.ab04b86s00Dao.add(ab04b86s00);
	}

	/**
	 * Updates a single row in the Ab04b86s00 table.
	 * 
	 *  ab04b86s00
	 *            Ab04b86s00
	 *  Ab04b86s00
	 *
	 * @param ab04b86s00 the ab 04 b 86 s 00
	 * @return the apartado anexo II
	 */
	@Transactional(rollbackFor = Throwable.class)
	public ApartadoAnexoII update(ApartadoAnexoII ab04b86s00) {
		return this.ab04b86s00Dao.update(ab04b86s00);
	}

	/**
	 * Finds a single row in the Ab04b86s00 table.
	 * 
	 *  ab04b86s00
	 *            Ab04b86s00
	 *  Ab04b86s00
	 *
	 * @param ab04b86s00 the ab 04 b 86 s 00
	 * @return the apartado anexo II
	 */
	public ApartadoAnexoII find(ApartadoAnexoII ab04b86s00) {
		return (ApartadoAnexoII) this.ab04b86s00Dao.find(ab04b86s00);
	}

	/**
	 * Deletes a single row in the Ab04b86s00 table.
	 * 
	 *  ab04b86s00
	 *            Ab04b86s00
	 *
	 * @param ab04b86s00 the ab 04 b 86 s 00
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(ApartadoAnexoII ab04b86s00) {
		this.ab04b86s00Dao.remove(ab04b86s00);
	}

	/**
	 * Finds a list of rows in the Ab04b86s00 table.
	 * 
	 *  ab04b86s00
	 *            Ab04b86s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<Ab04b86s00>
	 *
	 * @param ab04b86s00 the ab 04 b 86 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	public List<ApartadoAnexoII> findAll(ApartadoAnexoII ab04b86s00, JQGridRequestDto jqGridRequestDto) {
		return (List<ApartadoAnexoII>) this.ab04b86s00Dao.findAll(ab04b86s00, jqGridRequestDto);
	}

	/**
	 * Finds rows in the Ab04b86s00 table using like.
	 * 
	 *  ab04b86s00
	 *            Ab04b86s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<Ab04b86s00>
	 *
	 * @param ab04b86s00 the ab 04 b 86 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<ApartadoAnexoII> findAllLike(ApartadoAnexoII ab04b86s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		return (List<ApartadoAnexoII>) this.ab04b86s00Dao.findAllLike(ab04b86s00, jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the Ab04b86s00 table.
	 * 
	 *  filterAb04b86s00
	 *            Ab04b86s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *
	 * @param filterAb04b86s00 the filter ab 04 b 86 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 */
	public void removeMultiple(ApartadoAnexoII filterAb04b86s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		this.ab04b86s00Dao.removeMultiple(filterAb04b86s00, jqGridRequestDto, startsWith);
	}

	/**
	 * Filter method in the Ab04b86s00 table.
	 * 
	 *  filterAb04b86s00
	 *            Ab04b86s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  JQGridResponseDto<Ab04b86s00>
	 *
	 * @param filterAb04b86s00 the filter ab 04 b 86 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<ApartadoAnexoII> filter(ApartadoAnexoII filterAb04b86s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		List<ApartadoAnexoII> listaAb04b86s00 = this.ab04b86s00Dao.findAllLike(filterAb04b86s00, jqGridRequestDto,
				false);
		Long recordNum = this.ab04b86s00Dao
				.findAllLikeCount(filterAb04b86s00 != null ? filterAb04b86s00 : new ApartadoAnexoII(), false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<ApartadoAnexoII>> reorderSelection = this.ab04b86s00Dao.reorderSelection(filterAb04b86s00,
					jqGridRequestDto, startsWith);
			return new JQGridResponseDto<ApartadoAnexoII>(jqGridRequestDto, recordNum, listaAb04b86s00,
					reorderSelection);
		}
		return new JQGridResponseDto<ApartadoAnexoII>(jqGridRequestDto, recordNum, listaAb04b86s00);
	}

	/**
	 * Searches rows in the Ab04b86s00 table.
	 * 
	 *  filterAb04b86s00
	 *            Ab04b86s00
	 *  searchAb04b86s00
	 *            Ab04b86s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<TableRowDto<Ab04b86s00>>
	 *
	 * @param filterAb04b86s00 the filter ab 04 b 86 s 00
	 * @param searchAb04b86s00 the search ab 04 b 86 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<TableRowDto<ApartadoAnexoII>> search(ApartadoAnexoII filterAb04b86s00, ApartadoAnexoII searchAb04b86s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.ab04b86s00Dao.search(filterAb04b86s00, searchAb04b86s00, jqGridRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in Ab04b86s00 table.
	 * 
	 *  filterAb04b86s00
	 *            Ab04b86s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  Object
	 *
	 * @param filterAb04b86s00 the filter ab 04 b 86 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the object
	 */
	public Object reorderSelection(ApartadoAnexoII filterAb04b86s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		return this.ab04b86s00Dao.reorderSelection(filterAb04b86s00, jqGridRequestDto, startsWith);
	}

}
